/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations;

import java.util.Locale;
import lib.toma.animations.EasingRegistry;
import lib.toma.animations.IEasing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public enum Easings implements IEasing
{
    LINEAR(x -> x, "LIN"),
    EASE_IN_SINE(x -> 1.0f - MathHelper.func_76134_b((float)(Easings.piMulX(x) / 2.0f)), "IN SINE"),
    EASE_IN_CUBIC(x -> x * x * x, "IN CUBIC"),
    EASE_IN_QUINT(x -> x * x * x * x * x, "IN QUINT"),
    EASE_IN_QUAD(x -> x * x, "IN QUAD"),
    EASE_IN_QUART(x -> x * x * x * x, "IN QUART"),
    EASE_IN_EXP(x -> x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x - 10.0f), "IN EXP"),
    EASE_OUT_SINE(x -> MathHelper.func_76126_a((float)(Easings.piMulX(x) / 2.0f)), "OUT SINE"),
    EASE_OUT_CUBIC(x -> 1.0f - (float)Math.pow(1.0f - x, 3.0), "OUT CUBIC"),
    EASE_OUT_QUINT(x -> 1.0f - (float)Math.pow(1.0f - x, 5.0), "OUT QUINT"),
    EASE_OUT_QUAD(x -> 1.0f - (1.0f - x) * (1.0f - x), "OUT QUAD"),
    EASE_OUT_QUART(x -> 1.0f - (float)Math.pow(1.0f - x, 4.0), "OUT QUART"),
    EASE_OUT_EXP(x -> x == 1.0f ? 1.0f : 1.0f - (float)Math.pow(2.0, -10.0f * x), "OUT EXP"),
    EASE_IN_OUT_SINE(x -> -(MathHelper.func_76134_b((float)Easings.piMulX(x)) - 1.0f) / 2.0f, "INOUT SINE"),
    EASE_IN_OUT_CUBIC(x -> x < 0.5f ? 4.0f * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0f, "INOUT CUBIC"),
    EASE_IN_OUT_QUINT(x -> x < 0.5f ? 16.0f * x * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0f, "INOUT QUINT"),
    EASE_IN_OUT_QUAD(x -> x < 0.5f ? 2.0f * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0f, "INOUT QUAD"),
    EASE_IN_OUT_QUART(x -> x < 0.5f ? 8.0f * x * x * x * x : 1.0f - (float)Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0f, "INOUT QUART"),
    EASE_IN_OUT_EXP(x -> x == 0.0f ? 0.0f : (x == 1.0f ? 1.0f : (x < 0.5f ? (float)Math.pow(2.0, 20.0f * x - 10.0f) / 2.0f : (2.0f - (float)Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0f)), "INOUT EXP"),
    JUMP_START(x -> x > 0.0f ? 1.0f : 0.0f, "JUMP START"),
    JUMP_MIDDLE(x -> x > 0.5f ? 1.0f : 0.0f, "JUMP MIDDLE"),
    JUMP_END(x -> x == 1.0f ? 1.0f : 0.0f, "JUMP END"),
    EASE_IN_BACK(Easings::easeInBack, "IN BACK"),
    EASE_OUT_BACK(Easings::easeOutBack, "OUT BACK"),
    EASE_IN_OUT_BACK(Easings::easeInOutBack, "INOUT BACK");

    private final IEasingFunction function;
    private final String shortName;
    private ITextComponent displayComponent;

    private Easings(IEasingFunction function, String shortName) {
        this.function = function;
        this.shortName = shortName;
        EasingRegistry.getRegistry().register(this, (byte)this.ordinal());
    }

    private static float piMulX(float x) {
        return x * (float)Math.PI;
    }

    private static float easeInBack(float in) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return c3 * in * in * in - c1 * in * in;
    }

    private static float easeOutBack(float in) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(in - 1.0f, 3.0) + (double)c1 * Math.pow(in - 1.0f, 2.0));
    }

    private static float easeInOutBack(float in) {
        float c1 = 1.70158f;
        float c2 = c1 * 1.525f;
        return (float)((double)in < 0.5 ? Math.pow(2.0f * in, 2.0) * (double)((c2 + 1.0f) * 2.0f * in - c2) / 2.0 : (Math.pow(2.0f * in - 2.0f, 2.0) * (double)((c2 + 1.0f) * (in * 2.0f - 2.0f) + c2) + 2.0) / 2.0);
    }

    @Override
    public float ease(float in) {
        return this.function.ease(in);
    }

    @Override
    public byte getEasingId() {
        return (byte)this.ordinal();
    }

    @Override
    public void setEasingId(byte id) {
        throw new UnsupportedOperationException("Cannot set easing ID on enum type!");
    }

    @Override
    public String getEasingName() {
        return this.shortName;
    }

    @Override
    public ITextComponent getDisplayText() {
        if (this.displayComponent == null) {
            TextFormatting color = this.getColor();
            String name = this.getFullDisplayName();
            this.displayComponent = new StringTextComponent(color + name);
        }
        return this.displayComponent;
    }

    private String getFullDisplayName() {
        String lowercase = this.name().toLowerCase(Locale.ROOT);
        CharSequence[] words = lowercase.split("_");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            String formatted = word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1);
            words[i] = formatted;
        }
        return String.join((CharSequence)" ", words);
    }

    private TextFormatting getColor() {
        int i = this.ordinal();
        if (i == 0) {
            return TextFormatting.RED;
        }
        int j = (i - 1) % 3;
        switch (j) {
            case 0: {
                return TextFormatting.GREEN;
            }
            case 1: {
                return TextFormatting.YELLOW;
            }
            case 2: {
                return TextFormatting.RED;
            }
        }
        return TextFormatting.WHITE;
    }

    @FunctionalInterface
    public static interface IEasingFunction {
        public float ease(float var1);
    }
}

